#!/usr/bin/python3
"""Upotreba ./validate.py test/*.in*"""

import string


def check(lines):
    nl = []   # ispravno formatirane linije

    n, m = map(int, lines[0].split())
    assert 1 <= n <= 500, "n kriv"
    assert 1 <= m <= 500, "m kriv"
    nl.append("{} {}\n".format(n, m))

    row = [[] for x in range(n)]
    for i in range(n):
        row[i] = list(map(int, lines[i+1].split()))
        assert(len(row[i]) == m)
        for x in row[i]: assert 1 <= x <= 1000
        nl.append(('{}' + ' {}'*(m-1) + '\n').format(*row[i]))

    for i in range(m):
        ss = []
        for j in range(n):
            ss.append(row[j][i])
        assert len(set(ss)) == n

    q = int(lines[n+1])
    assert 1 <= q <= 10**6
    nl.append('{}\n'.format(q))
    for i in range(q):
        a, y, x = map(int, lines[n+2+i].split())
        assert 1 <= a <= m
        assert 1 <= y <= m
        assert 1 <= x <= n
        nl.append('{} {} {}\n'.format(a, y, x))

    assert lines == nl, "Krivi format (%s vs %s)" % (lines, nl)
    assert lines[-1][-1] == "\n", "Zadnji red ne zavrsava sa \\n"
    return n, m, q

# Ocekivani clusteri! Ovo vjerojatno zelis promijeniti!
expected_clusters = {'mali': 2, 'veci': 3, 'normalni': 5}

def what_cluster(data):
    n, m, q = data
    if n <= 100 and m <= 100 and q <= 1000:
        return 'mali'
    if q <= 1000:
        return 'veci'
    return 'normalni'

################### Zadatak-specifican kod iznad ove linije #########################

import sys
import glob
import hashlib


def group_in_batches(files):
    # mnozenje.in.1a, mnozenje.in.1b sprema u isti batch

    files.sort()
    B = []
    for f in files:
        if f[-1].islower() and len(B) > 0 and f[:-1] == B[-1][-1][:-1]:
            B[-1].append(f)
        else:
            B.append([f])
    return B


if __name__ == "__main__":
    f = []
    for pattern in sys.argv[1:]:
        for filename in glob.glob(pattern):
            f.append(filename)

    bc = []
    for batch in group_in_batches(f):
        if 'dummy' not in batch[0]:
            bc.append([])
        for filename in batch:
            print("{}: ".format(filename), end="")
            try:
                lines = open(filename).readlines()
                summary = check(lines)
                c = what_cluster(summary)
                if 'dummy' not in batch[0]:
                    bc[-1].append(c)
            except Exception as e:
                print("Greska!", e)
                raise
            else:
                print("Sve ok! (cluster {}, summary = {})".format(c, summary))

    clusters = {}
    for b in bc:
        for c in b:
            assert c == b[0], "Ima razlicitih cluster-a unutar batcha"
        if not b[0] in clusters:
            clusters[b[0]] = 0
        clusters[b[0]] += 1

    assert clusters == expected_clusters, "Kriva raspodjela clustera ({} vs {})".format(clusters, expected_clusters)

    # Buda test - provjeri duplikate
    hashes = set(hashlib.sha1(open(x, 'rb').read()).hexdigest() for x in f)
    assert len(hashes) == len(f), "Ima duplikata!"
